
// BIInvoice.h
// BISubstrate
// 
// Copyright (c) 2001 Marketcircle Inc. All rights reserved.


/*!
    @class       BIInvoice
    @abstract    BIInvoice represents an Invoice which was sent to the Client.
    @discussion  It has a reference to the working slips which compose it.  These slips are not modifiable once they have been invoiced.  Payments are applied against an invoice if a user decides.
 
                 ISSUES
 
                 - we should move out the subtotal, markup, discount, total logic out to another class which soley handles this.
 
                 - we should move out the tax calculation to the tax manager seems logical.
 
                 - we should remove all the old tax calculation stuff... ie. why is tax1 and tax2 still here?
*/


#ifdef BILLINGS_PRO
#import "_BPInvoice.h"
#endif
#ifdef BILLINGS_SINGLE
#import "_BIInvoice.h"
#endif
#import "BIAppVersioning.h"


enum {
	BIINVOICE_NOTSENT_STATE = 101,
	BIINVOICE_SENT_STATE = 102
};

@class BITax;
@class BIProject;

@interface BIInvoice : BL_SUPER_CLASSNAME_MUNGE(Invoice) 
{
	NSString *substituteProjectName;
}

// invoice number, escaped, mostly used for the export filename
- (NSString *)escapedName;
- (NSString *)archivableRepresentationName;

- (void)setTimeslips:(NSMutableArray*)theSlips;

- (NSNumber*)subTotalPlusMarkup;
- (void)setSubTotalPlusMarkup:(NSNumber*)aTotal;

- (NSNumber*)subTotalPlusMarkupMinusDiscount;
- (void)setSubTotalPlusMarkupMinusDiscount:(NSNumber*)aTotal;

- (NSNumber*)total;
- (void)setTotal:(NSNumber*)aTotal;
- (void)invalidateInvoiceTotalCached;

- (NSNumber*)subTotal;
- (void)setSubTotal:(NSNumber*)aSubTotal;

- (NSNumber*)tax1Total;
- (void)setTax1Total:(NSNumber*)aTotal;

- (NSNumber*)tax2Total;
- (void)setTax2Total:(NSNumber*)aTotal;

- (NSNumber*)combinedTaxTotal;
- (void)setCombinedTaxTotal:(NSNumber*)aTotal;

- (NSNumber*)markupTotal;
- (void)setMarkupTotal:(NSNumber*)aTotal;
- (NSNumber*)calculateMarkupTotalOnTotal:(NSNumber*)aSubtotal;

- (NSNumber*)discountTotal;
- (void)setDiscountTotal:(NSNumber*)aTotal;
- (NSNumber*)calculateDiscountTotalOnTotal:(NSNumber*)aSubtotal;

- (void)setDefaultValues;
- (void)setDefaultValuesWithObjectContext:(MCPObjectContext*)oc;

- (BOOL)isDueDate;
- (void)setIsDueDate:(BOOL)flag;

- (BOOL)isOverdue;
- (void)setIsOverdue:(BOOL)aFlag;
- (BOOL)willBeOverdue;

- (BOOL)isTaxPointDate;
- (void)setIsTaxPointDate:(BOOL)aFlag;

- (BOOL)isOutstanding;
- (void)setIsOutstanding:(BOOL)aFlag;

- (NSNumber *)balance;
- (void)setBalance:(NSNumber *)aBalance;
- (void)updateBalance;

- (id)method;
- (void)setMethod:(id)aMethod;

- (NSArray*)billableSlips;
- (void)setBillableSlips:(NSArray*)theSlips;

- (BOOL)useTax1Bool;
- (void)setUseTax1Bool:(BOOL)aFlag;

- (BOOL)useTax2Bool;
- (void)setUseTax2Bool:(BOOL)aFlag;

- (BOOL)compoundSecondaryTaxBool;
- (void)setCompoundSecondaryTaxBool:(BOOL)aFlag;

- (NSString*)stateName;
- (void)setStateName:(NSString*)aName;

- (NSArray*)contributeExportFields;
//- (NSArray*)expandKeysInExportFields:(NSArray*)fieldDicts;
- (NSArray*)dictionariesForExpandTaxTotals;
- (NSString*)tabDelimitedRepresentation:(NSArray*)fieldDicts;
- (void)exportSlipsToTabDelimitedPath:(NSString *)aFullPath;

- (NSNumber*)taxesTotal;

- (NSNumber*)markupTotalAsPercentageOfInvoice;
- (NSNumber*)discountTotalAsPercentageOfInvoice;

- (NSArray*)appliedTaxes;

- (NSArray*)combineAppliedTaxesWithSameNameAndRate:(NSArray*)appliedTaxes;

- (NSNumber*)subTotalNotIncludingMarkupAndDiscountFromSlips;
- (void)setSubTotalNotIncludingMarkupAndDiscountFromSlips:(NSNumber*)aTotal;

- (NSNumber*)taxTotalForTax:(BITax*)matchTax;

- (NSArray*)appliedTaxesWithAppliedRetainerAmount;
- (void)setAppliedTaxesWithAppliedRetainerAmount:(NSArray*)anArray;

- (NSNumber*)totalIncludingAppliedRetainerAmount;
- (void)setTotalIncludingAppliedRetainerAmount:(NSNumber*)aTotal;


- (NSDecimalNumber *)totalPastDue;
// adds the current total including applied retainer amount to the past due
- (NSDecimalNumber *)totalIncludingPastDueAndAppliedRetainerAmount;


- (NSNumber*)paymentsTotal;

- (NSCalendarDate*)statementDate;
- (void)setStatementDate:(NSCalendarDate*)aDate;

- (NSArray*)consolidateLikeTaxes:(NSArray*)taxesTotalArray;

- (void)setInitialValues;
- (void)setInitialValuesWithObjectContext:(id)oc;

- (NSArray *)slipsSummariesByKind;
- (NSArray *)slipsSummariesByWorker;
- (NSArray *)slipsSummariesByCategory;

- (NSArray *)projects;

- (NSString *)projectName;
- (NSString *)projectNickname;
- (NSString *)projectCode;
- (NSString *)projectPONumber;
- (NSString *)projectExtraField1;
- (NSString *)projectExtraField2;
- (NSString *)projectExtraField3;
- (NSString *)projectExtraField4;

- (NSString *)substituteProjectName;
- (void)setSubstituteProjectName:(NSString *)aSubstituteProjectName;

- (NSCalendarDate *)dateForAccount;

- (NSString *)html;
- (BOOL)needsPDFGeneratedFromHTML;
- (void)generatePDFFromHTML;


- (NSNumberFormatter *)currencyFormatter;

// applies exchange rate factor if client is using foreign currency. This can be inaccurate!!! Because it applies the current exchange rate to a potential old invoice
- (NSNumber *)exchangedBaseTotal;


- (NSString *)objectNumber;

/*!
 An array of BIPayment of type 'retainer' for the client, BIRetainer for the client and the BIPayment of type 'retainer' for this invoice. This method is labelled temporary because it only makes sense when creating the invoice.  
 */
- (NSArray *)temporaryRetainerHistory;
- (NSDecimalNumber *)temporaryRetainerBalance;
- (NSDecimalNumber *)temporaryAppliedRetainerAmount;


/*!
 Used for summary info on certain invoice templates
 */
- (NSDecimalNumber *)calculationForSlipType:(NSInteger)typeOne 
									typeTwo:(NSInteger)typeTwo 
								  typeThree:(NSInteger)typeThree 
								   selector:(SEL)numberSelector;
- (NSDecimalNumber *)subTotalOfTimedAndFlat;
- (NSDecimalNumber *)subTotalOfExpenseMileageAndQuantity;


- (NSArray *)timedAndFlatSlips;
- (NSArray *)expenseMileageAndQuantitySlips;


@end
